#!/bin/sh

date=`./clsmtpc -V |head -1 |cut -d' ' -f3,4`
if [ $date ];then
    date="September 2011"
fi

version=`./clsmtpc -V|head -1 |cut -d' ' -f2`
version=${version%-*}

preface="
.\\\"Dd January 19, 2003
.\\\"Os linux
.\\\"Dt clsmtpc(1)
.TH clsmtpc \"1\" \"$date\" \"clsmtpc $version\" \"User Commands\"
.SH NAME
clsmtpc \\- simple non-interactive command line SMTP client
.\\\"Nm clsmtpc
.\\\"Nd simple non-interactive command line mailer
.SH SYNOPSIS
.B clsmtpc
[options] \"mail text\"
.br
.B clsmtpc
[options] -m <file>
.br
echo \"mail text\" |
.B clsmtpc
[options] 
.SH DESCRIPTION"

postscript=".SH EXAMPLES
To send an email from fine@pri.royal.sk.fb to rein@pri.royal.sk.fb by mail.royal.sk.fb with digest-md5, in this example, the ID for authentication with digest-md5 is user ID of sender address and the password is read from default password file(/etc/clsmtpc/clmpasswd).

\$ clsmtpc -F fine@pri.royal.sk.fb -T rein@pri.royal.sk.fb -M mail.royal.sk.fb -A digest-md5 -s \"Re: Trouble! Trouble!\" \"Can't send an email!\"

.nf
clsmtpc-$version-: ************ 2011-08-29 Mon 20:26 ************
.br
clsmtpc-${version}>: 220 mail.royal.sk.fb ESMTP Postfix
.br
clsmtpc-${version}<: EHLO localhost
.br
clsmtpc-${version}>: 250-mail.royal.sk.fb
ls
.br
clsmtpc-${version}<: 250-PIPELINING
.br
clsmtpc-${version}<: 250-SIZE 10240000
.br
clsmtpc-${version}<: 250-VRFY
.br
clsmtpc-${version}<: 250-ETRN
.br
clsmtpc-${version}<: 250-AUTH DIGEST-MD5 CRAM-MD5 PLAIN LOGIN
.br
clsmtpc-${version}<: 250 8BITMIME
.br
clsmtpc-${version}>: AUTH DIGEST-MD5
.br
clsmtpc-${version}<: 334 bm9uY2U9IkRvTm90WW91SGF2ZUFueXRoaW5nQmV0dGVyVG9Eb1dpdGhZb3VyVGltZT09IixyZWFsbT0ibWFpbC5yb3lhbC5zay5mYiIscW9wPSJhdXRoIixjaGFyc2V0PXV0Zi04LGFsZ29yaXRobT1tZDUtc2Vzcw==
.br
clsmtpc-${version}>: dXNlcm5hbWU9ImZpbmUiLHJlYWxtPSJtYWlsLnJveWFsLnNrLmZiIixub25jZT0iRG9Ob3RZb3VIYXZlQW55dGhpbmdCZXR0ZXJUb0RvV2l0aFlvdXJUaW1lPT0iLGRpZ2VzdC11cmk9InNtdHAvbWFpbC5yb3lhbC5zay5mYiIscW9wPWF1dGgsbmM9MDAwMDAwMDEsY25vbmNlPSJmMGFjYTIyMzk4NjRmMmNjMjgyOWUxZWQzOTFlMzdmYyIscmVzcG9uc2U9MWQxNzVjYTZmYTI5M2JlNWVjZjc0NWVjYjMzYWVkZTkK
.br
clsmtpc-${version}<: 334 cnNwYXV0aD0zMmY5MGQwNWY3OWQ3OTU4NzY2MjYxOTllNTZiNDE1Mw==
.br
clsmtpc-${version}>: 
.br
clsmtpc-${version}<: 235 Authentication successful
.br
clsmtpc-${version}>: MAIL FROM: <fine@pri.royal.sk.fb>
.br
clsmtpc-${version}<: 250 Ok
.br
clsmtpc-${version}>: RCPT TO: <rein@pri.royal.sk.fb>
.br
clsmtpc-${version}<: 250 Ok
.br
clsmtpc-${version}>: DATA
.br
clsmtpc-${version}<: 354 End data with <CR><LF>.<CR><LF>
.br
From:  <fine@pri.royal.sk.fb>
.br
To:  <rein@pri.royal.sk.fb>
.br
Subject: Re: Trouble! Trouble!
.br
X-Mailer: clsmtpc-${version}
.br
Mime-Version: 1.0
.br
Content-Type: text/plain; charset=US-ASCII
.br
Content-Transfer-Encoding: 7BIT
.br

Can't send an email!
.br
\&.
.br
clsmtpc-${version}<: 250 Ok: queued as 4794656901
.br
clsmtpc-${version}>: QUIT
.br
clsmtpc-${version}<: 221 2.0.0 Bye
.fi

---------------------
.br
If you send an email in multibyte character codeset (ex. Japanese), select an appropriate charset(-C) and encode type(-e). In this example, ISO-2022-JP charset coded in 7-bit is selected for mail body. But in the mail header name and subject are encoded in base64.

$ clsmtpc -F makoto@sakakino.ac.jp -M mail.sakakino.ac.jp -T itaru@overflow.example.jp -s \"中の人の件\" -N \"いとう まこと\" -A plain -U makoto -r niceboat -C iso-2022-jp -e 7bit \"はじめに言葉ありき、つづいて世界ありし\"

.nf
.br
clsmtpc-${version}-: ************ 2011-08-28 Sun 12:14 ************
.br
clsmtpc-${version}<: 220 mail.sakakino.ac.jp ESMTP Postfix
.br
clsmtpc-${version}>: EHLO c13.sakakino.ac.jp
.br
clsmtpc-${version}<: 250-mail.sakakino.ac.jp
.br
clsmtpc-${version}<: 250-PIPELINING
.br
clsmtpc-${version}<: 250-SIZE 10240000
.br
clsmtpc-${version}<: 250-VRFY
.br
clsmtpc-${version}<: 250-ETRN
.br
clsmtpc-${version}<: 250-AUTH DIGEST-MD5 CRAM-MD5 PLAIN LOGIN
.br
clsmtpc-${version}<: 250 8BITMIME
.br
clsmtpc-${version}>: AUTH PLAIN bWFrb3RvAG1ha290bwBuaWNlYm9hdAo=
.br
clsmtpc-${version}<: 235 Authentication successful
.br
clsmtpc-${version}>: MAIL FROM: <makoto@sakakino.ac.jp>
.br
clsmtpc-${version}<: 250 Ok
.br
clsmtpc-${version}>: RCPT TO: <itaru@overflow.example.jp>
.br
clsmtpc-${version}<: 250 Ok
.br
clsmtpc-${version}>: DATA
.br
clsmtpc-${version}<: 354 End data with <CR><LF>.<CR><LF>
.br
From: =?ISO-2022-JP?B?GyRCJCQkSCQmGyhCIBskQiReJDMkSBsoQg==?= <makoto@sakakino.ac.jp>
.br
To  <itaru@overflow.example.jp>
.br
Subject: =?ISO-2022-JP?B?GyRCQ2YkTj9NJE43bxsoQg==?=
.br
X-Mailer: clsmtpc-${version}
.br
Mime-Version: 1.0
.br
Content-Type: text/plain; charset=ISO-2022-JP
.br
Content-Transfer-Encoding: 7BIT
.br

はじめに言葉ありき、つづいて世界ありし
.br
\&.
.br
clsmtpc-${version}<: 250 Ok: queued as 6F2E7568E8
.br
clsmtpc-${version}>: QUIT
.br
clsmtpc-${version}<: 221 2.0.0 Bye
.fi
.SH BUGS
A specific combination of charset and encode type may cause garbling on a specific MUA.
.SH SEE ALSO
bash(1), iconv(1), file(1)
.SH AUTHOR
yoshinobu syouzi <yoshino@rita.karing.jp>
"

echo "$preface"
p=0
while read l ;do
    if [ $p = 0 ];then
	if [ "$l" ];then
	    continue
	else
	    p=1
	fi
    else
	if [ "$l" ];then
	    if [ "$readme" ];then
		readme="$readme $l"
	    else
		readme=$l
	    fi
	else
	    break
	fi
    fi
done <README
echo "$readme
.SH OPTIONS
"
p=0
nl=0
while read l ;do
    if [ "$l" != "options;" ]&&[ $p = 0 ];then
	continue
    else
	if [ $p = 0 ];then
	    p=1
	    continue
	fi
    fi

    if [ "${l:0:1}" = "-" ];then
	op=$l
	op_v=1
	if [ "$info_str" ];then
	    echo "$info_str"
	    info_str=""
	fi
	echo ".TP
.B \"$op\""
	continue
    else
	info_l=`echo "$l"`

	if [ ! "$info_l" ];then
	    continue
	fi

	if [ "$info_str" ];then

	    if [ "${info_l// /}" = "${info_l}" ];then

		if [ $nl = 0 ];then
		    info_str="$info_str
.br
$info_l"
		else
		    info_str="$info_str
$info_l"
		    nl=0
		fi
	    elif [ ! "${info_l#*\;}" ];then
		info_str="$info_str
.br
$info_l
.br"
		nl=1
	    else
		if [ $nl = 0 ];then
		    info_str="$info_str $info_l"
		else
		    info_str="$info_str
$info_l"
		    nl=0
		fi
	    fi
	else
	    info_str=$info_l
	fi
    fi
done <<EOF
`./clsmtpc -h| sed 's/\\\\/\\\\\\\\\\\\\\\\/g'`
EOF
echo "$info_str"
echo "$postscript"